
********************************************************************
**************city size on housing market project*******************
********************************************************************
gen lnrent_h=log( h_for_rent_home_lease_averagepri)
gen lnrent_u=log( u_for_rent_home_lease_averagepri)
gen lnhouse_price=log( h_sold_both_auction_private_trea)
gen lnunit_price=log( u_sold_both_auction_private_trea)
gen lnest_pop =log( est_pop)
gen lnvisa_granted=log( visa_granted)
gen lnplanned_intake=log( plannedintake)
gen lnnew_migrant_ave=log( new_migrant_average)
gen lnnew_migrant_sum=log( new_migrant_sum)


//generate lga and state id for panel construction // 
egen stateid=group(state)
egen lgaid=group(lga)

// declare panel model// 

sort lga state year 

xtset lgaid year 


// analyse climate zone, population and housing market in australia // 

gen warm_humid_sum_mild_winter =1 if climatezoen==2
replace warm_humid_sum_mild_winter=0 if warm_humid_sum_mild_winter==.

gen mild_temperate=1 if climatezoen==6
replace mild_temperate=0 if mild_temperate==.

gen warm_temperate=1 if climatezoen==5
replace warm_temperate=0 if warm_temperate==.

gen cool_temperate=1 if climatezoen==7
replace cool_temperate=0 if cool_temperate==.


gen high_humid_sum_warm_winter= 1 if climatezoen==1
replace high_humid_sum_warm_winter= 0 if high_humid_sum_warm_winter==.


gen hot_dry_sum_cool_winter=1 if climatezoen==4
replace hot_dry_sum_cool_winter=0 if hot_dry_sum_cool_winter==.



// the impact of est_pop on housing market (without IV) // 

xtreg lnrent_h lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
xtreg lnrent_h lnest_pop l.lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
xtreg lnrent_h lnest_pop l.lnest_pop l.l.lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
  
  
xtreg lnrent_u lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
xtreg lnrent_u lnest_pop l.lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
xtreg lnrent_u lnest_pop l.lnest_pop l.l.lnest_pop i.year i.year#stateid, fe vce (cl lgaid) 
  
  


xtreg lnrent_h lnest_pop  lnhouse_pric population_employment labour_participation i.year i.year#stateid, fe vce (cl lgaid)

xtreg lnrent_h l.lnest_pop lnhouse_pric population_employment labour_participation i.year i.year#stateid, fe vce (cl lgaid)


xtreg lnrent_u lnest_pop  lnunit_price population_employment labour_participation i.year i.year#stateid, fe vce (cl lgaid) 

xtreg lnrent_u l.lnest_pop lnunit_price population_employment labour_participation i.year i.year#stateid, fe vce (cl lgaid) 
  
  
  
********************************************************************************************************************
$$$$888*
 $// first-stage// 
 $// climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate) //  
 $// visa_granted as IV // 
 
 $gen city_size_1 = warm_humid_sum_mild_winter*lnvisa_granted 
 $gen city_size_2= mild_temperate*lnvisa_granted 
 $gen city_size_3= warm_temperate*lnvisa_granted
 $gen favourable_climate_1=1 if climatezoen==2 | climatezoen==6 | climatezoen==5
 $replace favourable_climate_1=0 if favourable_climate_1==. 
 $gen city_size_4= favourable_climate_1*lnvisa_granted 
 
 // contemporary effect //  
 $xtreg lnest_pop city_size_1 city_size_2 city_size_3 i.year i.year#i.stateid, fe vce (cl lgaid)
  
 $test  city_size_1 city_size_2 city_size_3 // F=27.29 // 
 
 $xtreg lnest_pop  city_size_4 i.year i.year#i.stateid, fe vce (cl lgaid)
   
 *test city_size_4 //F=77.54// 
 *
 *xtreg lnrent_h city_size_1 city_size_2 city_size_3 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are not good // 
 *xtreg lnrent_u city_size_1 city_size_2 city_size_3 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are not good // 
 *xtreg lnrent_h city_size_4 lnindustry_employment lnhouse_price  i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 *xtreg lnrent_u city_size_4 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 
 
 // lag one // 
 *gen city_size_1_lag_one = warm_humid_sum_mild_winter*lnvisa_granted_lag_one 
 *gen city_size_2_lag_one= mild_temperate*lnvisa_granted_lag_one 
 *gen city_size_3_lag_one= warm_temperate*lnvisa_granted_lag_one
 *gen city_size_4_lag_one= favourable_climate_1*lnvisa_granted_lag_one 
 
  
  
 *xtreg lnest_pop city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one i.year i.year#i.stateid, fe vce (cl lgaid)
 
 *test  city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one // F=27.50 //
 
 *xtreg lnest_pop  city_size_4_lag_one i.year i.year#i.stateid, fe vce (cl lgaid)
  
 *test city_size_4_lag_one //F=78.15// 
  
 
  
 *xtreg lnrent_h city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are not good // 
 *xtreg lnrent_u city_size_1 city_size_2 city_size_3 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are not good // 
 *xtreg lnrent_h city_size_4 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 *xtreg lnrent_u city_size_4 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
  
  

  
  // planned level as IV // 
  // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate) //
 // contemporary effect // 
 *gen city_size_5 = warm_humid_sum_mild_winter*lnplanned_intake
 *gen city_size_6= mild_temperate*lnplanned_intake
 *gen city_size_7= warm_temperate*lnplanned_intake
 *gen city_size_8= favourable_climate_1*lnplanned_intake 
  
 *xtreg lnest_pop city_size_5 city_size_6 city_size_7 i.year i.year#i.stateid, fe vce (cl lgaid) 
 
* test city_size_5 city_size_6 city_size_7 // F= 27.16 // 
 
* xtreg  lnest_pop city_size_8 i.year i.year#i.stateid, fe vce (cl lgaid)
 
 *test  city_size_8   // F= 77.13 // 
 
*xtreg lnrent_h city_size_5 city_size_6 city_size_7 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // all bad // 
*xtreg lnrent_u city_size_5 city_size_6 city_size_7 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6 are not good // 
*xtreg lnrent_h city_size_8 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
*xtreg lnrent_u city_size_8 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 



*xtreg lnrent_h city_size_8 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //
*xtreg lnrent_u city_size_8 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //




    
// lag one // 

 *gen city_size_5_lag_one = warm_humid_sum_mild_winter*lnplanned_intake_lag_one
 *gen city_size_6_lag_one= mild_temperate*lnplanned_intake_lag_one
 *gen city_size_7_lag_one= warm_temperate*lnplanned_intake_lag_one
 *gen city_size_8_lag_one= favourable_climate_1*lnplanned_intake_lag_one
 
 
 *xtreg lnest_pop city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one i.year i.year#i.stateid, fe vce (cl lgaid) 
 
* test city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one  // F= 27.34 // 
 
  *xtreg  lnest_pop city_size_8_lag_one i.year i.year#i.stateid, fe vce (cl lgaid)
 
  *test city_size_8_lag_one  // F= 77.64 // 
  
  
*xtreg lnrent_h city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6 are bad  // 
*xtreg lnrent_u city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6 are bad // 
*xtreg lnrent_h city_size_8_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
*xtreg lnrent_u city_size_8_lag_one lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 

 
*xtreg lnrent_h city_size_8_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
*xtreg lnrent_u city_size_8_lag_one population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //
 
 
 
 
 
 
// migrant level as IV // 
// climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate) //
// contemporary effect //  
 
 *gen city_size_9 = warm_humid_sum_mild_winter*lnnew_migrant_sum
 *gen city_size_10= mild_temperate*lnnew_migrant_sum
 *gen city_size_11= warm_temperate*lnnew_migrant_sum
 *gen city_size_12= favourable_climate_1*lnnew_migrant_sum   
  
  
 *xtreg lnest_pop city_size_9 city_size_10 city_size_11 i.year i.year#i.stateid, fe vce (cl lgaid) 
 
 *test city_size_9 city_size_10 city_size_11 // F= 28.27 // 
 
  
  *xtreg  lnest_pop city_size_12 i.year i.year#i.stateid, fe vce (cl lgaid)
 
  *test city_size_12  //F=80.71 // 
  
  *xtreg lnrent_h city_size_9 city_size_10 city_size_11 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 9 and 10 are not good // 
  *xtreg lnrent_u city_size_9 city_size_10 city_size_11 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 9 and 10 are not good //
  *xtreg lnrent_h city_size_12 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  
  *xtreg lnrent_u city_size_12 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad result // 
  
  
  *xtreg lnrent_h city_size_12 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  
  *xtreg lnrent_u city_size_12 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad result // 
  
  
  
 // migrant level as IV // 
// climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate) //
// lag one //    

 *gen city_size_9_lag_one = warm_humid_sum_mild_winter*lnnew_migrant_s_lag_one
 *gen city_size_10_lag_one= mild_temperate*lnnew_migrant_s_lag_one
 *gen city_size_11_lag_one= warm_temperate*lnnew_migrant_s_lag_one
 *gen city_size_12_lag_one= favourable_climate_1*lnnew_migrant_s_lag_one   
  
 *xtreg lnest_pop city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one i.year i.year#i.stateid, fe vce (cl lgaid) 
 *test city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one // F= 26.49// 
 
 *xtreg  lnest_pop city_size_12_lag_one i.year i.year#i.stateid, fe vce (cl lgaid)
  *test city_size_12_lag_one // F=74.99 // 
  
  
*xtreg lnrent_h city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // all bad results // 
*xtreg lnrent_u city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)   // city 9 and 10 are bad // 
*xtreg lnrent_h city_size_12_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad result //
*xtreg lnrent_u city_size_12_lag_one lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad result //



*xtreg lnrent_h city_size_12_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad result //
*xtreg lnrent_u city_size_12_lag_one population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)    // bad result //

 
  
  
  
  
  
  
 // first-stage// 
 // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // visa_granted as IV //   
  
 gen city_size_13=cool_temperate*lnvisa_granted
 gen favourable_climate_2=1 if climatezoen==2 | climatezoen==6 | climatezoen==5 | climatezoen==7
 replace favourable_climate_2=0 if favourable_climate_2==. 
 gen city_size_14= favourable_climate_2*lnvisa_granted
 
 
   
  
 xtreg lnest_pop city_size_1 city_size_2 city_size_3 city_size_13 i.year i.year#i.stateid, fe vce (cl lgaid)
  
 test  city_size_1 city_size_2 city_size_3 city_size_13  // F= 21.13 // 
 
 xtreg lnest_pop  city_size_14 i.year i.year#i.stateid, fe vce (cl lgaid)
  
  
 test city_size_14  // F= 78.46// 
 
 

 
  
 *xtreg lnrent_h city_size_1 city_size_2 city_size_3 city_size_13 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are bad // 
 *xtreg lnrent_u city_size_1 city_size_2 city_size_3 city_size_13 lnindustry_employment lnunit_price  i.year i.year#i.stateid, fe vce (cl lgaid) // city 1, 2 and 13 are bad // 
 *xtreg lnrent_h city_size_14 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 
 *xtreg lnrent_u city_size_14 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
 

 xtreg lnrent_u city_size_14  lnunit_price population_employment i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_u city_size_14  lnunit_price labour_participation i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_u city_size_14  lnunit_price population_employment labour_participation i.year i.year#i.stateid, fe vce (cl lgaid)
 
 
 
  
 xtreg lnrent_h city_size_14  lnhouse_price population_employment i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_h city_size_14  lnhouse_price labour_participation i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_h city_size_14  lnhouse_price population_employment labour_participation i.year i.year#i.stateid, fe vce (cl lgaid)
  
 
 // two-stage least square // 
 
 xtivreg lnrent_u lnunit_price population_employment i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) 
 
 xtivreg lnrent_h lnhouse_price population_employment i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) 
 
 
 
 xtivreg lnrent_u lnunit_price labour_participation i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) // not significant for population// 
 xtivreg lnrent_h lnhouse_price labour_participation i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) 
 
 
 xtivreg lnrent_u lnunit_price population_employment labour_participation i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) // not significant for population// 
  
 xtivreg lnrent_h lnhouse_price population_employment labour_participation i.year i.year#i.stateid (lnest_pop=city_size_14), fe vce (cl lgaid) 
 
 
 *xtreg d_lnrent_u city_size_14  lnunit_price population_employment labour_participation i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 *xtreg d_lnrent_h city_size_14  lnunit_price population_employment labour_participation i.year i.year#i.stateid, fe vce (cl lgaid)
  

 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid) // result is just ok// 
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid) // result is not so good// 
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid) // result is not so good//
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_14), cluster (lgaid)
 
 
 
 
 // lag one // 
  // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // visa_granted as IV // 
 gen city_size_15_lag_one=cool_temperate*lnvisa_granted_lag_one
 gen city_size_16_lag_one = favourable_climate_2*lnvisa_granted_lag_one
  
  xtreg lnest_pop city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one city_size_15_lag_one i.year i.year#i.stateid, fe vce (cl lgaid)
  test city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one city_size_15_lag_one  // F=21.30 // 
  xtreg lnest_pop city_size_16_lag_one  i.year i.year#i.stateid, fe vce (cl lgaid)
  test city_size_16_lag_one  // F=79.14// 
  
  
  
  
 *xtreg lnrent_h city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one city_size_15_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 1 and 2 are bad // 
 *xtreg lnrent_u city_size_1_lag_one city_size_2_lag_one city_size_3_lag_one city_size_15_lag_one lnindustry_employment lnunit_price  i.year i.year#i.stateid, fe vce (cl lgaid) // city 2, 2 and 15 are bad // 
 *xtreg lnrent_h city_size_16_lag_one lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
 *xtreg lnrent_u  city_size_16_lag_one lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
 
 
 
 xtreg lnrent_h city_size_16_lag_one population_employment  lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_h city_size_16_lag_one labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
 xtreg lnrent_h city_size_16_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
 
 
 
 xtreg lnrent_u city_size_16_lag_one population_employment  lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
 
 xtreg lnrent_u city_size_16_lag_one labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
 
 xtreg lnrent_u city_size_16_lag_one population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
 
 
 
 *xtreg d_lnrent_h city_size_16_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
 *xtreg d_lnrent_u city_size_16_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
 
 
 
 
 
 
 
 
  // two-stage least square // 
 
 xtivreg lnrent_u lnunit_price population_employment i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid) 
 
 xtivreg lnrent_h lnhouse_price population_employment i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid) 
 
 
 
 xtivreg lnrent_u lnunit_price labour_participation i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid) 
 
 xtivreg lnrent_h lnhouse_price labour_participation i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid) 
 
 
 xtivreg lnrent_u lnunit_price population_employment labour_participation i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid)  
  
 xtivreg lnrent_h lnhouse_price population_employment labour_participation i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), fe vce (cl lgaid) 
 
 
 
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_16_lag_one), cluster (lgaid)
 
 
 
 
 
 
 
 
 
 
 // contemporary and lag one // 
 
 xtreg lnest_pop city_size_14 city_size_16_lag_one  i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary is negative but not significant// 
 test city_size_14 city_size_16_lag_one // F(  2,   417) =   49.65// 
 
 xtreg lnrent_h city_size_14 city_size_16_lag_one population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary is negative but not significant//
 
 xtreg lnrent_h city_size_14 city_size_16_lag_one population_employment  lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // contemporary is negative but not significant//
 
 xtreg lnrent_h city_size_14 city_size_16_lag_one labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // contemporary is negative but not significant//
 
 
 
 xtreg lnrent_u city_size_14 city_size_16_lag_one population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary is negative but not significant//
 
  xtreg lnrent_u city_size_14 city_size_16_lag_one population_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary is negative but not significant//
 
  xtreg lnrent_u city_size_14 city_size_16_lag_one labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary is negative but not significant//
 
 
 
  
 // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // planned level as IV //  
 // contemporary effect //  
  gen city_size_17= cool_temperate*lnplanned_intake
  gen city_size_18= favourable_climate_2*lnplanned_intake
  
  xtreg lnest_pop city_size_5 city_size_6 city_size_7 city_size_17 i.year i.year#i.stateid, fe vce (cl lgaid) 
   test city_size_5 city_size_6 city_size_7 city_size_17  // F=21.20 // 
   xtreg  lnest_pop city_size_18 i.year i.year#i.stateid, fe vce (cl lgaid) 
  test  city_size_18 // F=77.96 // 
  
   
  
*xtreg lnrent_h city_size_5 city_size_6 city_size_7 city_size_17 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6 are bad// 
*xtreg lnrent_u city_size_5 city_size_6 city_size_7 city_size_17 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6, 17 are bad // 
*xtreg lnrent_h city_size_18 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 
*xtreg lnrent_u city_size_18 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) 



xtreg lnrent_h city_size_18 population_employment  lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 

xtreg lnrent_h city_size_18 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 

xtreg lnrent_h city_size_18 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 



xtreg lnrent_u city_size_18 population_employment  lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) 

xtreg lnrent_u city_size_18 labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) 

xtreg lnrent_u city_size_18 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) 


*xtreg d_lnrent_h city_size_18 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 
*xtreg d_lnrent_u city_size_18 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results// 




// two stage least square// 

xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 

xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 

xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 


xtivreg lnrent_u population_employment lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 

xtivreg lnrent_u labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 

xtivreg lnrent_u population_employment labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_18), fe vce (cl lgaid) 





 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid) 
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid)
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_18), cluster (lgaid)
 
 
 







  // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // planned level as IV //  
 // lag one //   
  
  gen city_size_19 = cool_temperate* lnplanned_intake_lag_one
  gen city_size_20 = favourable_climate_2*lnplanned_intake_lag_one 
  
  
  xtreg lnest_pop city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one city_size_19 i.year i.year#i.stateid, fe vce (cl lgaid)
  test city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one city_size_19  // F= 21.17// 
  
  xtreg lnest_pop city_size_20 i.year i.year#i.stateid, fe vce (cl lgaid) 
  test city_size_20  // F=78.57// 
  
  
  *xtreg lnrent_h city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one city_size_19 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6 are bad// 
  *xtreg lnrent_u city_size_5_lag_one city_size_6_lag_one city_size_7_lag_one city_size_19 lnindustry_employment lnunit_price  i.year i.year#i.stateid, fe vce (cl lgaid) // city 5 and 6, 19 are bad // 
  *xtreg lnrent_h city_size_20 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
  *xtreg lnrent_u city_size_20 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) 
 
  
  
  xtreg lnrent_h city_size_20 population_employment  lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  xtreg lnrent_h city_size_20 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  xtreg lnrent_h city_size_20 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  
  
  xtreg lnrent_u city_size_20 population_employment  lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  xtreg lnrent_u city_size_20 labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  xtreg lnrent_u city_size_20 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)
  
  
   *xtreg d_lnrent_h city_size_20 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
   *xtreg d_lnrent_u city_size_20 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
  
  
  
  // two stage least square// 

xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 

xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 

xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 


xtivreg lnrent_u population_employment lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 

xtivreg lnrent_u labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 

xtivreg lnrent_u population_employment labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_20), fe vce (cl lgaid) 


  
  

 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid) 
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid)
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_20), cluster (lgaid)
 
   
  
  
  
  
  // contemporary + lag one// 
  
  xtreg  lnest_pop city_size_18 city_size_20 i.year i.year#i.stateid, fe vce (cl lgaid)
  test city_size_18 city_size_20  //F= F(  2,   417) =   42.08// 
  xtreg lnrent_u city_size_18 city_size_20 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // lag is not significant // 
   xtreg lnrent_h city_size_18 city_size_20 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // both are not significant // 
   
  
  
  xtreg lnrent_u city_size_18 city_size_20 population_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // contemporary effect is not significant// 
  xtreg lnrent_u city_size_18 city_size_20 labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // contemporary effect is not significant // 
 
   
  
   xtreg lnrent_h city_size_18 city_size_20 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // contemporary effect is negative and not significant// 
   
   xtreg lnrent_h city_size_18 city_size_20 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)   // contemporary effect is negative and not significant// 
   
  
  
  
  // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // migrant level as IV //
 // contemporary effect // 
 
  
 gen  city_size_21 = cool_temperate*lnnew_migrant_sum 
 gen  city_size_22 = favourable_climate_2*lnnew_migrant_sum
  
  
  
 xtreg lnest_pop city_size_9 city_size_10 city_size_11 city_size_21 i.year i.year#i.stateid, fe vce (cl lgaid) 
 
 test city_size_9 city_size_10 city_size_11 city_size_21  // F=21.90 // 
 
 
 xtreg lnest_pop city_size_22 i.year i.year#i.stateid, fe vce (cl lgaid)
  
  test city_size_22  // F=  81.65 // 
  
  
*xtreg lnrent_h city_size_9 city_size_10 city_size_11 city_size_21 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // city 9 and 10 are bad // 
*xtreg lnrent_u city_size_9 city_size_10 city_size_11 city_size_21 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // city 9, 10 and 21 are bad // 
*xtreg lnrent_h city_size_22 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) 
*xtreg lnrent_u city_size_22 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 



xtreg lnrent_h city_size_22 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
xtreg lnrent_h city_size_22 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)
xtreg lnrent_h city_size_22 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_u city_size_22 population_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results //  
xtreg lnrent_u city_size_22 labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //  
xtreg lnrent_u city_size_22 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)   // bad results // 



*xtreg d_lnrent_h city_size_22 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results // 
*xtreg d_lnrent_u city_size_22 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid) // bad results //   






  // two stage least square// 

xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) 

xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) 

xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) 


xtivreg lnrent_u population_employment lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) // not significant // 

xtivreg lnrent_u labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) // not significant //

xtivreg lnrent_u population_employment labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_22), fe vce (cl lgaid) // not significant // 







  // climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
 // migrant level as IV //
 // lag one // 
  
 gen city_size_23 = cool_temperate*lnnew_migrant_s_lag_one
 gen city_size_24 = favourable_climate_2*lnnew_migrant_s_lag_one 
 
 
 
  
  
 xtreg lnest_pop city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one city_size_23 i.year i.year#i.stateid, fe vce (cl lgaid) 
 test city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one city_size_23 // F= 20.45 // 
 
 xtreg  lnest_pop city_size_24 i.year i.year#i.stateid, fe vce (cl lgaid)
  test city_size_24 // F=75.19 // 
  
  
  
  
*xtreg lnrent_h city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one city_size_23 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // all results are bad // 
*xtreg lnrent_u city_size_9_lag_one city_size_10_lag_one city_size_11_lag_one city_size_23 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)   // city size 9, 10 and 23 are bad // 
*xtreg lnrent_h city_size_24 lnindustry_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results // 
*xtreg lnrent_u city_size_24 lnindustry_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)  


 
xtreg lnrent_h city_size_24 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //   
xtreg lnrent_h city_size_24  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //   
xtreg lnrent_h city_size_24 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)  // bad results //   
      


	  
	  
	  
xtreg lnrent_u city_size_24 population_employment lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)     
xtreg lnrent_u city_size_24  labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)    
xtreg lnrent_u city_size_24 population_employment labour_participation lnunit_price i.year i.year#i.stateid, fe vce (cl lgaid)    
     

  
  
*xtreg d_lnrent_h city_size_24 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)    // bad results // 
*xtreg d_lnrent_u city_size_24 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)    // bad results // 
  
  
  
  
   // two stage least square// 

xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid) // not significant //

xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid)  // not significant //

xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid)  // not significant //


xtivreg lnrent_u population_employment lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid) // not significant //

xtivreg lnrent_u labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid) // not significant //

xtivreg lnrent_u population_employment labour_participation lnunit_price i.year i.year#i.stateid (lnest_pop = city_size_24), fe vce (cl lgaid) // not significant //

 
  
  
  
  
  
  
  
  
 // contemporary + lag one//
 
xtreg lnest_pop city_size_22 city_size_24 i.year i.year#i.stateid, fe vce (cl lgaid) 

xtreg lnrent_h city_size_22 city_size_24 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_22 city_size_24 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_h city_size_22 city_size_24 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_22 city_size_24 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 
 
xtreg lnrent_h city_size_22 city_size_24 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_22 city_size_24 labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

 
 
// climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
// total_visa_1 as IV // 


gen lntotal_visa_1=log(total_visa_1)
gen city_size_27=favourable_climate_2*lntotal_visa_1


xtreg lnest_pop city_size_27 i.year i.year#i.stateid, fe vce (cl lgaid)
test city_size_27   


gen lntotal_visa_1_lag_one = log(total_visa_1_lag_one)
gen city_size_28=favourable_climate_2*lntotal_visa_1_lag_one

xtreg lnest_pop city_size_28 i.year i.year#i.stateid, fe vce (cl lgaid)
test city_size_28  





xtreg lnrent_h city_size_27 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_27 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_h city_size_27  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_27  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 
xtreg lnrent_h city_size_27 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_27 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)






xtreg lnrent_h city_size_28 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_28 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_h city_size_28  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_28  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 
xtreg lnrent_h city_size_28 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_28 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)



 // two stage least square // 
 
 
xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)

xtivreg lnrent_u population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)


xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)

xtivreg lnrent_u labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)



xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)

xtivreg lnrent_u population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_27), fe vce (cl lgaid)




xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)

xtivreg lnrent_u population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)


xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)

xtivreg lnrent_u labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)



xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)

xtivreg lnrent_u population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_28), fe vce (cl lgaid)







 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid) 
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid)
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_27), cluster (lgaid)
 
   

   
   
   
   
 ivreg2 lnrent_u lnunit_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid)  
 
 ivreg2 lnrent_h lnhouse_price population_employment i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid)
 
 
 ivreg2 lnrent_u lnunit_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid) 
 
 ivreg2 lnrent_h lnhouse_price labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid)
 
 
 
 ivreg2 lnrent_u lnunit_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid)
 
 ivreg2 lnrent_h lnhouse_price population_employment labour_participation i.lgaid i.year i.year#i.stateid (lnest_pop=city_size_28), cluster (lgaid)
 
   
 




// climate zones are 2(warm_humid_sum_mild_winter),6(mild_temperate),5(warm_temperate), 7(cool_temperate) //  
// total_visa_2 as IV // 



gen lntotal_visa_2=log(total_visa_2)
gen city_size_29=favourable_climate_2*lntotal_visa_2


xtreg lnest_pop city_size_29 i.year i.year#i.stateid, fe vce (cl lgaid)
test city_size_29   


gen lntotal_visa_2_lag_one = log(total_visa_2_lag_one)
gen city_size_30=favourable_climate_2*lntotal_visa_2_lag_one

xtreg lnest_pop city_size_30 i.year i.year#i.stateid, fe vce (cl lgaid)
test city_size_30

 
xtreg lnrent_h city_size_29 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_29 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_h city_size_29  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_29  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 
xtreg lnrent_h city_size_29 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_29 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)




xtreg lnrent_h city_size_30 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_30 population_employment lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


xtreg lnrent_h city_size_30  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_30  labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 
xtreg lnrent_h city_size_30 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)

xtreg lnrent_u city_size_30 population_employment labour_participation lnhouse_price i.year i.year#i.stateid, fe vce (cl lgaid)


 // two stage least square // 
 
 
xtivreg lnrent_h population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)

xtivreg lnrent_u population_employment lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)


xtivreg lnrent_h labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)

xtivreg lnrent_u labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)



xtivreg lnrent_h population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)

xtivreg lnrent_u population_employment labour_participation lnhouse_price i.year i.year#i.stateid (lnest_pop = city_size_29), fe vce (cl lgaid)

